Attribute VB_Name = "Assembly"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999-2002 Parametric Technology Corporation.
'       All rights reserved.

Function menuAddComponent(componentName As String)

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

cfobject.AddComponent componentName

api.CommitCalls "AddComponent", pause

End Function


Function menuAlignPlanes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim geometricSet As ObjectSet
Set geometricSet = activePart.GetSelection("Geometric")

Dim geometricSetIt As iterator
Set geometricSetIt = prod.GetClass("It").CreateAObjectIt(geometricSet)

If (geometricSet.IsEmpty) Then
    MsgBox "Faces/Workplanes not Selected"
    Exit Function
End If

If (geometricSet.GetAnyMember.IsA("Geometric")) Then

    If (geometricSet.GetCount = 2) Then
    
        If (geometricSetIt.start.GetGeometricForm.IsA("Plane") And geometricSetIt.Next.GetGeometricForm.IsA("Plane")) Then
            
            If (Not (geometricSetIt.start.GetParent("DesignInstance") Is geometricSetIt.Next.GetParent("DesignInstance"))) Then
                cfobject.AlignPlanes activePart.GetDesign, geometricSetIt.start, geometricSetIt.Next, 0, "align" & CStr(alignVarCount)
                alignVarCount = alignVarCount + 1
            Else
                MsgBox "The Faces/Workplanes selected are from the same Component"
                Exit Function
            End If
        Else
            MsgBox "The Selected Faces/Workplanes are not Planar"
            Exit Function
        End If
            
    Else
        MsgBox "More than Two Faces/Workplanes Selected"
        Exit Function
    End If
            
Else
    MsgBox "Entities selected are not Faces/Workplanes"
    Exit Function
End If

api.CommitCalls "AlignPlanes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuMatePlanes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim geometricSet As ObjectSet
Set geometricSet = activePart.GetSelection("Geometric")

Dim geometricSetIt As iterator
Set geometricSetIt = prod.GetClass("It").CreateAObjectIt(geometricSet)

If (geometricSet.IsEmpty) Then
    MsgBox "Faces/Workplanes not Selected"
    Exit Function
End If

If (geometricSet.GetAnyMember.IsA("Geometric")) Then

    If (geometricSet.GetCount = 2) Then
    
        If (geometricSetIt.start.GetGeometricForm.IsA("Plane") And geometricSetIt.Next.GetGeometricForm.IsA("Plane")) Then
            
            If (Not (geometricSetIt.start.GetParent("DesignInstance") Is geometricSetIt.Next.GetParent("DesignInstance"))) Then
                cfobject.MatePlanes activePart.GetDesign, geometricSetIt.start, geometricSetIt.Next, 0, "mate" & CStr(mateVarCount)
                mateVarCount = mateVarCount + 1
            Else
                MsgBox "The Faces/Workplanes selected are from the same Component"
                Exit Function
            End If
        Else
            MsgBox "The Selected Faces/Workplanes are not Planar"
            Exit Function
        End If
            
    Else
        MsgBox "More than Two Faces/Workplanes Selected"
        Exit Function
    End If
            
Else
    MsgBox "Entities selected are not Faces/Workplanes"
    Exit Function
End If

api.CommitCalls "MatePlanes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuCenterAxes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim geometricSet As ObjectSet
Set geometricSet = activePart.GetSelection("Geometric")

Dim geometricSetIt As iterator
Set geometricSetIt = prod.GetClass("It").CreateAObjectIt(geometricSet)

If (geometricSet.IsEmpty) Then
    MsgBox "Faces/Circular Lines not Selected"
    Exit Function
End If

If (geometricSet.GetAnyMember.IsA("Geometric") Or geometricSet.GetAnyMember.IsA("Edge") Or geometricSet.GetAnyMember.IsA("Line")) Then

    If (geometricSet.GetCount = 2) Then
        
        Dim topo1 As aGeometric
        Dim topo2 As aGeometric
        Set topo1 = geometricSetIt.start
        Set topo2 = geometricSetIt.Next
        
        If ((topo1.GetGeometricForm.IsA("Circle") And topo2.GetGeometricForm.IsA("Circle")) Or (topo1.GetGeometricForm.IsA("Cylinder") And topo2.GetGeometricForm.IsA("Cylinder"))) Then
            
            If (Not (topo1.GetParent("DesignInstance") Is topo2.GetParent("DesignInstance"))) Then
                cfobject.CenterAxes topo1, topo2
            Else
                MsgBox "The Faces/Edges/Lines selected are from the same Component"
                Exit Function
            End If
        Else
            MsgBox "The Selected Entities are not Circular/Cylindrical"
            Exit Function
        End If
            
    Else
        MsgBox "More than Two Faces/Edges/Lines Selected"
        Exit Function
    End If
            
Else
    MsgBox "Entities selected are not Faces, Edges or Circular Lines"
    Exit Function
End If

api.CommitCalls "CenterAxes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function

Function menuOrientAxes()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim geometricSet As ObjectSet
Set geometricSet = activePart.GetSelection("Geometric")

Dim geometricSetIt As iterator
Set geometricSetIt = prod.GetClass("It").CreateAObjectIt(geometricSet)

If (geometricSet.IsEmpty) Then
    MsgBox "Improper selection"
    Exit Function
End If

If (geometricSet.GetAnyMember.IsA("Geometric")) Then

    If (geometricSet.GetCount = 2) Then
        Dim first, second As zGeometry
        Set first = geometricSetIt.start.GetGeometricForm()
        Set second = geometricSetIt.Next.GetGeometricForm()
    
        If ((first.IsA("Straight") And second.IsA("Straight")) Or (first.IsA("Plane") And second.IsA("Plane")) Or (first.IsA("Cylinder") And second.IsA("Cylinder")) Or (first.IsA("Cone") And second.IsA("Cone"))) Then
        
            If (Not (geometricSetIt.start.GetParent("DesignInstance") Is geometricSetIt.Next.GetParent("DesignInstance"))) Then
                cfobject.OrientAxes geometricSetIt.start, geometricSetIt.Next
            Else
                MsgBox "The selected entities are from the same Component"
                Exit Function
            End If
        Else
            MsgBox "The Selected entities are not having a fixed normal"
            Exit Function
        End If
            
    Else
        MsgBox "More than Two entities Selected"
        Exit Function
    End If
            
Else
    MsgBox "Entities selected are not having a fixed normal"
    Exit Function
End If

api.CommitCalls "OrientAxes", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function


Function menuMassProperties()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim density As Double
Dim mass As Double
Dim volume As Double
Dim area As Double
Dim cofgPoint As zVector
Dim momentOfInertia As zMatrix
Dim principalMomentsOfInertia As zVector
Dim principalAxes As zMatrix
Dim radiusOfGyration As zVector

Let density = 5
cfobject.MassProperties density, mass, volume, area, cofgPoint, momentOfInertia, principalMomentsOfInertia, principalAxes, radiusOfGyration

MsgBox ("The Volume in mm3 = " & volume * 1000000000#)
MsgBox ("The Area in mm2 = " & area * 1000000#)

api.CommitCalls "MassProperties", pause

Exit Function

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Function

End Function



